#ifndef __THREAD_MONITOR_REGISTRAR_H__
#define __THREAD_MONITOR_REGISTRAR_H__

/*********************************************************************
    File Name:    ThreadMonitorRegistrar.h
    Description:  tools for registering keys for use with CThreadMonitor.
    Author:       Eric Fredericksen
    Comments:

Copyright (c) 2003-2010, Eric Fredericksen
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   This product includes software developed by Eric Fredericksen.
4. Neither the name of Eric Fredericksen nor the
   name of PTTP Systems may be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY ERIC FREDERICKSEN ''AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL ERIC FREDERICKSEN BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
   
**********************************************************************/

#include <atlbase.h>

#define _PRODUCT_ TEXT("PTTP Systems\\ThreadMonitor")
#define _VERSION_NUMBER_ TEXT("1.2")

class CThreadMonitorRegistrar : public CRegKey
{
protected:
	CString m_oRegPath;
	CString m_oKeyName;

	enum { DELETE_NO_KEY, DELETE_KEY_RECURSIVE, DELETE_KEY_IF_EMPTY };
	DWORD m_dwDeleteStrategy;
public:
	LPCTSTR GetRegPath(void) { return(m_oRegPath); }
	LPCTSTR GetKeyname(void) { return(m_oKeyName); }

	CRegKey m_oParent;

	void CreateKey( LPCTSTR _lpParentPath, LPCTSTR _pKeyName, DWORD _dwDeleteStrategy=DELETE_KEY_RECURSIVE )
	{
		
		// open the parent key in preparation for deleting this key and its offspring
		m_oRegPath.Format( _T("%s"), _lpParentPath);
		m_oParent.Create(HKEY_LOCAL_MACHINE, m_oRegPath);
		m_dwDeleteStrategy = _dwDeleteStrategy;
		
		// save the key name
		m_oKeyName.Format(  _T("%s"), _pKeyName);
		
		// create the key 
		m_oRegPath.Format( _T("%s\\%s"), _lpParentPath, _pKeyName);
		Create(HKEY_LOCAL_MACHINE, m_oRegPath);
	}
	

	CThreadMonitorRegistrar(void)
	{
		m_dwDeleteStrategy = DELETE_NO_KEY;
		m_oRegPath = "";
		m_oKeyName = "";
	}

	virtual ~CThreadMonitorRegistrar()
	{
		Close();
		long lResult;
		switch(m_dwDeleteStrategy)
		{
		case DELETE_KEY_RECURSIVE:
			lResult = m_oParent.RecurseDeleteKey(m_oKeyName);
			break;

		case DELETE_KEY_IF_EMPTY:
			lResult = m_oParent.DeleteSubKey(m_oKeyName);
			break;
		}
		
	}

};

class CRegisterProcess : public CThreadMonitorRegistrar
{
public:
	
	CRegisterProcess( LPCTSTR _ptcProcessName=0) { Register(_ptcProcessName); }

	void Register( LPCTSTR _ptcProcessName )
	{
		if( NULL == _ptcProcessName ) return;
		CString oBaseName;
		oBaseName.Format(TEXT("Software\\%s\\%s"), _PRODUCT_, _VERSION_NUMBER_);
		CreateKey( oBaseName, _ptcProcessName );
	}
	
};

class CRegisterThread : public CThreadMonitorRegistrar
{
public:
	
	void Register(CRegisterProcess & _roProcess, LPCTSTR _ptcThreadTagName, DWORD _dwThreadID=-1)
	{
		if( _dwThreadID == (DWORD)-1 ) _dwThreadID = GetCurrentThreadId();
		
		CString oThreadID;
		oThreadID.Format( TEXT("0x%X"), _dwThreadID);
		CString oKeyPath;
		oKeyPath.Format( TEXT("%s\\Threads"), _roProcess.GetRegPath() );
		CreateKey(oKeyPath, oThreadID);
		long lResult = SetStringValue(NULL, _ptcThreadTagName);
	}
	
	void SetKeyValue(CRegisterProcess & _roProcess, 
		DWORD _dwValue, 
		LPCTSTR _ptcName, 
		DWORD _dwThreadID=-1
		)
	{
		if( _dwThreadID == (DWORD)-1 ) _dwThreadID = GetCurrentThreadId();
		
		CString oThreadID;
		oThreadID.Format( TEXT("0x%X"), _dwThreadID);
		CString oKeyPath;
		oKeyPath.Format( TEXT("%s\\Threads"), _roProcess.GetRegPath() );
		CreateKey(oKeyPath, oThreadID);
		long lResult = SetDWORDValue(_ptcName, _dwValue );
	}
	
	void SetKeyValue(CRegisterProcess & _roProcess, 
		LPCTSTR _ptcValue, 
		LPCTSTR _ptcName, 
		DWORD _dwThreadID=-1
		)
	{
		if( _dwThreadID == (DWORD)-1 ) _dwThreadID = GetCurrentThreadId();

		CString oThreadID;
		oThreadID.Format( TEXT("0x%X"), _dwThreadID);
		CString oKeyPath;
		oKeyPath.Format( TEXT("%s\\Threads"), _roProcess.GetRegPath() );
		CreateKey(oKeyPath, oThreadID);
		long lResult = SetStringValue(_ptcName, _ptcValue );
	}
	
};

#endif // __THREAD_MONITOR_REGISTRAR_H__
